set terminal epslatex size 15.5cm,3.5cm color colortext
set output 'gnuplottex/jidm2015-gnuplottex-fig4.tex'
load 'defaultgnuplot.cfg'
unset key
set tmargin 0.8
set bmargin 3.6
set rmargin 1.0
unset grid
set style data lines
set xtics rotate scale 0,0
set ylabel "CPU or Network cost"
set multiplot layout 1,4
set xlabel "$\\id{tradeoff}$" offset 0,1
set title '$Q1$' offset 0,-0.5
plot 'fig/tradeoffq1.txt' u 1:2 lw 3 lt 2, '' u 1:3 lw 3 lt 3, '' u 1:4 lw 3 lt 4, '' u 1:5 lw 3 lt 5
set title '$Q3$'
plot 'fig/tradeoffq3.txt' u 1:2 lw 3 lt 2, '' u 1:3 lw 3 lt 3, '' u 1:4 lw 3 lt 4, '' u 1:5 lw 3 lt 5
set title '$Q5$'
plot 'fig/tradeoffq5.txt' u 1:2 lw 3 lt 2, '' u 1:3 lw 3 lt 3, '' u 1:4 lw 3 lt 4, '' u 1:5 lw 3 lt 5
set key box linestyle 12 at screen 0.9,0.1 vertical maxrows 1
set key samplen 2
set title '$Q8$'
plot 'fig/tradeoffq8.txt' u 1:2 lw 3 lt 2 ti 'Balance $P_1$', '' u 1:3 lw 3 lt 3 ti 'Balance $P_2$', '' u 1:4 lw 3 lt 4 ti 'Comm. $P_1$', '' u 1:5 lw 3 lt 5 ti 'Comm. $P_2$'
